define([
    'underscore',
    'moment',
    'modules/new-appointment-request/resources/common/facility/express-time-model',
], function(_, moment, Model) {
    'use strict';

    describe('Express Times Model', function() {
        var data;

        beforeEach(function() {
            data = {
                start: '08:00',
                end: '17:00',
                timezone: 'CST',
                offsetUtc: '-06:00',
            };
        });

        it('generates the correct message', function() {
            var model = new Model(data);
            var expected = 'Express Care request at this location must be submitted before 17:00 CST.';

            expect(model.getExpressMessage()).toBe(expected);
        });

        it('sets the time correctly', function() {
            var model = new Model(data);
            var expectedTime = '14:00:00-06:00';
            // Strictly speaking, this test could fail if run exactly at midnight, and the expected date ends up
            // being on the day before the actual date.
            var expectedDate = moment().format('YYYY-MM-DD');
            var expectedStr = expectedDate + 'T' + expectedTime;
            var time = '14:00';
            var date = model._offsetTime(time);
            var dateStr = date.format();

            expect(dateStr).toBe(expectedStr);
        });

        it('checks if a date is between two dates correctly', function() {
            // This is basically testing moment.js, here for coverage reasons
            var model = new Model(data);
            var today = moment();
            var yesterday = moment();
            var tomorrow = moment();

            yesterday.subtract(1, 'day');
            tomorrow.add(1, 'day');

            expect(model._between(today, yesterday, tomorrow)).toBeTruthy();
            expect(model._between(yesterday, today, tomorrow)).toBeFalsy();
        });

        xit('checks if isExpressAvailable returns true when it is', function() {
            var model;
            data.start = '00:00';
            data.end = '23:59';
            model = new Model(data);
            expect(model.isExpressAvailable()).toBeTruthy();
        });

        xit('checks if isExpressAvailable returns true when it is available', function() {
            var model;
            data.start = '00:00';
            data.end = '23:59';
            model = new Model(data);
            expect(model.isExpressAvailable()).toBeTruthy();
        });

        it('checks if isExpressAvailable returns false when it is not available', function() {
            var today = moment();
            var isMorning = today.format('A') === 'AM';
            var model;

            if (isMorning) {
                data.start = '23:00';
                data.end = '23:59';
            } else {
                data.start = '00:00';
                data.end = '00:59';
            }

            model = new Model(data);
            expect(model.isExpressAvailable()).toBeFalsy();
        });
    });
});
